<?php
class imagesUtils {

	const PNG_FORMAT			= 1;
	const JPG_FORMAT			= 2;
	const GIF_FORMAT			= 3;

	private static $imageHolder		= null;
	private static $originalFormat  = null;
	private static $originalSize	= array();

	public static function processImgHTML($html) {

		preg_match_all("/<img([^>]*)>/si",$html,$matches,PREG_SET_ORDER);
		if ($matches) {
			foreach($matches as $match) {
				$imgParams=self::getTagParameters($match[1]);
				$style="";
				if ($imgParams["style"]) {
					$css=self::processInlineCSS($imgParams["style"]);
					if ($css["float"])
						$style=" style=\"float: {$css["float"]};\"";
				}
				if ($imgParams["alt"])
					$html=str_replace($match[0],"<div{$style}>".$match[0]."<br/><div class=\"epigrafe\">".$imgParams["alt"]."</div></div>",$html);

			}
		}

		return $html;

	}

	public static function getTagParameters($strParameters) {
		preg_match_all("/([a-z\-_]*)=\"([^\"]*)\"/si",$strParameters,$matches,PREG_SET_ORDER);
		$parameters=array();
		if ($matches) {
			foreach($matches as $match) {
				$parameters[strtolower($match[1])]=$match[2];
			}
		}
		return $parameters;
	}

	public static function processInlineCSS($inlineCSS) {
		$inlineCSS=trim($inlineCSS);
		if (substr($inlineCSS,-1)!=";") $inlineCSS.=";";
		preg_match_all("/([a-z\-]*):([^;]*);/si",$inlineCSS,$matches,PREG_SET_ORDER);
		$css=array();
		if ($matches) {
			foreach ($matches as $match) {
				$css[strtolower($match[1])]=trim($match[2]);
			}
		}
		return $css;
	}

	public static function getScaledSize($image,$maxWidth,$maxHeight) {
		if (!file_exists($_SERVER["DOCUMENT_ROOT"].$image)) {
			return array("width"=>0,"height"=>0);
		}
		$imageInfo=@getimagesize($_SERVER["DOCUMENT_ROOT"].$image);

		$width=$imageInfo[0];
		$height=$imageInfo[1];

		if ($width>$maxWidth) {
			$scale=$maxWidth/$width;
			$width=$maxWidth;
			$height=$imageInfo[1]*$scale;
		}
		if ($height>$maxHeight) {
			$scale=$maxHeight/$height;
			$height=$maxHeight;
			$width=$width*$scale;
		}
		return array("width"=>$width,"height"=>$height);
	}

	public static function getRemoteImage($url,$localFile,$width,$height) {
		$im=@imagecreatefromjpeg($url);
		if (!$im) $im=@imagecreatefrompng($url);
		if (!$im) $im=@imagecreatefromgif($url);

		if (is_dir(dirname($localFile))) {

		}
	}

	public static function loadImage($filename) {
		ini_set("memory_limit","128M");
		$image_info = getimagesize($filename);
		$image_type = $image_info[2];
		switch ($image_type) {
			case IMAGETYPE_JPEG:
				self::$originalFormat=self::JPG_FORMAT;
				self::$imageHolder = @imagecreatefromjpeg($filename);
				break;
			case IMAGETYPE_GIF:
				self::$originalFormat=self::GIF_FORMAT;
				self::$imageHolder = @imagecreatefromgif($filename);
				break;
			case IMAGETYPE_PNG:
				self::$originalFormat=self::PNG_FORMAT;
				self::$imageHolder = @imagecreatefrompng($filename);
				imagealphablending(self::$imageHolder, false);
				break;
		 }
		 return self::isLoaded();
	}
	public static function isLoaded() {
		return is_resource(self::$imageHolder);
	}

	public static function getWidth() {
		return imagesx(self::$imageHolder);
	}

	public static function getHeight() {
		return imagesy(self::$imageHolder);
	}

	public static function copyImage($dst_x,$dst_y,$src_x,$src_y,$src_w,$src_h,$dst_w=0,$dst_h=0) {
		$dst_w=ceil($dst_w);
		$dst_h=ceil($dst_h);
		$src_w=ceil($src_w);
		$src_h=ceil($src_h);
		if ($dst_w && $dst_h) {
			$dst=imagecreatetruecolor($dst_w,$dst_h);
		} else {
			$dst=imagecreatetruecolor($src_w,$src_h);
		}
		$white = imagecolorallocate($dst, 255, 255, 255);
		imagefill($dst,0,0,$white);
		imagecopy($dst,self::$imageHolder,$dst_x,$dst_y,$src_x,$src_y,$src_w,$src_h);
		$tmpName=sys_get_temp_dir()."/".md5(uniqid(time())).".png";
		@imagepng($dst,$tmpName);
		self::loadImage($tmpName);
		@unlink($tmpName);
		imagedestroy($dst);

	}

	public static function enlargePicture($maxWidth,$maxHeight) {
		$width=self::getWidth();
		$height=self::getHeight();
		if ($width<$maxWidth || $height<$maxHeight) {
			if ($width<$maxWidth) {
				$scaleWidth=$maxWidth / $width;
				$newHeight=$height*$scaleWidth;
				$newWidth=$width*$scaleWidth;
			} else {
				$scaleHeight=$maxHeight / $height;
				$newHeight=$height*$scaleHeight;
				$newWidth=$width*$scaleHeight;
			}
			$newImg=imagecreatetruecolor($newWidth,$newHeight);
			imagecopyresampled($newImg,self::$imageHolder,0,0,0,0,$newWidth,$newHeight,$width,$height);
			$tmpName=sys_get_temp_dir()."/".md5(uniqid(time())).".png";
			@imagepng($newImg,$tmpName);
			self::loadImage($tmpName);
			@unlink($tmpName);
			imagedestroy($newImg);
			$width=self::getWidth();
			$height=self::getHeight();
			self::enlargePicture($maxWidth,$maxHeight);
		}
	}

	public static function scaleHorizontalPicture($maxWidth,$maxHeight) {
		$width=self::getWidth();
		$height=self::getHeight();

		$scale=$maxWidth / $width;
		$newHeight=$height*$scale;
		$newWidth=$maxWidth;
		if ($newHeight<$maxHeight) {
			$scale=$maxHeight/$height;
			$newWidth=$width*$scale;
			$newHeight=$maxHeight;
		}
		$newImg=imagecreatetruecolor($newWidth,$newHeight);
		imagecopyresampled($newImg,self::$imageHolder,0,0,0,0,$newWidth,$newHeight,$width,$height);
		$tmpName=sys_get_temp_dir()."/".md5(uniqid(time())).".png";
		@imagepng($newImg,$tmpName);
		self::loadImage($tmpName);
		@unlink($tmpName);
		imagedestroy($newImg);
	}

	public static function scaleVerticalPicture($maxWidth,$maxHeight) {
		$width=self::getWidth();
		$height=self::getHeight();

		$scale=$maxHeight/$height;
		$newWidth=$width*$scale;
		$newHeight=$maxHeight;
		if ($newWidth<$maxWidth) {
			$scale=$maxWidth / $width;
			$newHeight=$height*$scale;
			$newWidth=$maxWidth;
		}

		$newImg=imagecreatetruecolor($newWidth,$newHeight);
		imagecopyresampled($newImg,self::$imageHolder,0,0,0,0,$newWidth,$newHeight,$width,$height);

		// Ahora tenemos una imagen temporal que tiene como minimo el acho o el alto requeridos
		$tmpName=sys_get_temp_dir()."/".md5(uniqid(time())).".png";
		@imagepng($newImg,$tmpName);
		self::loadImage($tmpName);
		@unlink($tmpName);
		imagedestroy($newImg);
	}

	public static function resizePicture($origFile,$destFile,$maxWidth,$maxHeight,$format=false) {
		self::loadImage($origFile);

		if (!$format) $format=self::$originalFormat;

		$width=self::getWidth();
		$height=self::getHeight();

		self::$originalSize=array("width"=>$width,"height"=>$height);
		if ($maxWidth>$maxHeight) {
			if ($height>$width) {
				self::swap($maxWidth,$maxHeight);
			}
		} else if ($maxWidth<$maxHeight) {
			if ($height<$width) {
				self::swap($maxWidth,$maxHeight);
			}
		}

		self::enlargePicture($maxWidth,$maxHeight);
		switch ($format) {
			case self::JPG_FORMAT:
				$retVal=imagejpeg(self::$imageHolder,$destFile);
				break;
			case self::GIF_FORMAT:
				$retVal=imagegif(self::$imageHolder,$destFile);
				break;
			case self::PNG_FORMAT:
			default:
				$retVal=imagepng(self::$imageHolder,$destFile);
				break;
		}
		$nameParts=explode(".",basename($destFile));
		$extension=array_pop($nameParts);
		$fileName=implode(".",$nameParts);
		$jsonFile=dirname($destFile)."/".$fileName.".json";
		file_put_contents($jsonFile, json_encode(self::$originalSize));

		return array("status"=>"ok");

		$width=self::getWidth();
		$height=self::getHeight();

		if ($width > $maxWidth && $height > $maxHeight) {
			// Seria el caso A
			if ($width>=$height)
				self::scaleHorizontalPicture($maxWidth,$maxHeight);
			else if($width<$height)
				self::scaleVerticalPicture($maxWidth,$maxHeight);
		}
		$width=self::getWidth();
		$height=self::getHeight();

		if ($width >= $maxWidth && $height == $maxHeight) {
			$centroImagen=($width/2);
			$anchoExcedente=($width-$maxWidth)/2;
			self::copyImage(0,0,$anchoExcedente,0,$maxWidth,$height);
		} else if ($width == $maxWidth && $height >= $maxHeight) {
			$centroImagen=($height/2);
			$altoExcedente=($height-$maxHeight)/2;
			self::copyImage(0,0,0,$altoExcedente,$width,$maxHeight);
		}

		switch ($format) {
			case self::JPG_FORMAT:
				$retVal=imagejpeg(self::$imageHolder,$destFile);
				break;
			case self::GIF_FORMAT:
				$retVal=imagegif(self::$imageHolder,$destFile);
				break;
			case self::PNG_FORMAT:
			default:
				$retVal=imagepng(self::$imageHolder,$destFile);
				break;
		}
		return array("status"=>"ok");
	}

	public static function swap(&$a,&$b) {
		$_=$a;
		$a=$b;
		$b=$_;
	}
}
