<?php
// force commit

Application::Uses("sys.db.model");
Application::Uses("sys.tools.utils.fileUtils");
Application::uses("sys.network.clients.ftp");
Application::Uses('sys.tools.utils.passwordUtils');
Application::Uses("sys.db.traits.auditable");

Application::UsesModel("activities");
Application::UsesModel("rules");
Application::UsesModel("roles");
Application::UsesModel("rules_roles");
Application::UsesModel("usuarios_roles");
Application::UsesModel("mensajes");
Application::UsesModel("usuarios_roles_habilitados");
Application::UsesModel("perfiles_usuarios");
Application::UsesModel("tickets");
Application::UsesModel("tickets_historial");

class TModelUsuarios extends TModel {
//	use TAuditableTrait;

	protected $table="tbl_usuarios";

	public $indexField="usr_codigo";
	private $permissions=array();
	private $roles=array();

	protected $dates=array('usr_registrado','usr_uvisita');
	protected $fillable=array(
		'usr_parent',
		'usr_estado',
		'usr_user',
		'usr_pass',
		'usr_nombre',
		'usr_apellido',
		'usr_titulo',
		'usr_pais',
		'usr_ciudad',
		'usr_direccion',
		'usr_telefono',
		'usr_email',
		'usr_css_scheme',
		'usr_empresa',
		'usr_registrado',
		'usr_ftp_host',
		'usr_ftp_user',
		'usr_ftp_password',
        'usr_ftp_folder',
        'usr_ftp_url',
		'usr_uvisita',
		'usr_ulogout',
		'usr_enable_chat',
		'usr_enable_chat_notifications',
	);

	protected function setupTableStructure() {
		$this->structure=array(
			"fields"=>array(
				"usr_codigo"=>array("type"=>"int","length"=>"11","extra"=>"unsigned NOT NULL AUTO_INCREMENT",),
				"usr_parent"=>array("type"=>"int","length"=>"11","extra"=>"NOT NULL DEFAULT '0'",),
				"usr_estado"=>array("type"=>"int","length"=>"11","extra"=>"NOT NULL DEFAULT '0'",),
				"usr_user"=>array("type"=>"varchar","length"=>"64","extra"=>"COLLATE latin1_spanish_ci NOT NULL DEFAULT ''",),
				"usr_pass"=>array("type"=>"varchar","length"=>"40","extra"=>"COLLATE latin1_spanish_ci NOT NULL DEFAULT ''",),
				"usr_nombre"=>array("type"=>"varchar","length"=>"255","extra"=>"COLLATE latin1_spanish_ci NOT NULL DEFAULT ''",),
				"usr_apellido"=>array("type"=>"varchar","length"=>"255","extra"=>"COLLATE latin1_spanish_ci NOT NULL DEFAULT ''",),
				"usr_titulo"=>array("type"=>"varchar","length"=>"64","extra"=>"COLLATE latin1_spanish_ci NOT NULL",),
				"usr_pais"=>array("type"=>"varchar","length"=>"255","extra"=>"COLLATE latin1_spanish_ci NOT NULL",),
				"usr_ciudad"=>array("type"=>"varchar","length"=>"255","extra"=>"COLLATE latin1_spanish_ci NOT NULL",),
				"usr_direccion"=>array("type"=>"varchar","length"=>"255","extra"=>"COLLATE latin1_spanish_ci NOT NULL DEFAULT ''",),
				"usr_telefono"=>array("type"=>"varchar","length"=>"255","extra"=>"COLLATE latin1_spanish_ci NOT NULL DEFAULT ''",),
				"usr_email"=>array("type"=>"varchar","length"=>"255","extra"=>"COLLATE latin1_spanish_ci NOT NULL DEFAULT ''",),
				"usr_empresa"=>array("type"=>"varchar","length"=>"255","extra"=>"COLLATE latin1_spanish_ci NOT NULL DEFAULT ''",),
				"usr_css_scheme"=>array("type"=>"varchar","length"=>"64","extra"=>"COLLATE latin1_spanish_ci NOT NULL DEFAULT ''",),
				"usr_registrado"=>array("type"=>"datetime","length"=>"","extra"=>"NOT NULL DEFAULT '0000-00-00 00:00:00'",),
				"usr_uvisita"=>array("type"=>"datetime","length"=>"","extra"=>"NOT NULL DEFAULT '0000-00-00 00:00:00'",),
				"usr_ulogout"=>array("type"=>"datetime","length"=>"","extra"=>"NOT NULL DEFAULT '0000-00-00 00:00:00'",),
				"usr_ftp_host"=>array("type"=>"varchar","length"=>"254","extra"=>"COLLATE latin1_spanish_ci NOT NULL DEFAULT ''",),
				"usr_ftp_user"=>array("type"=>"varchar","length"=>"64","extra"=>"COLLATE latin1_spanish_ci NOT NULL DEFAULT ''",),
				"usr_ftp_password"=>array("type"=>"varchar","length"=>"64","extra"=>"COLLATE latin1_spanish_ci NOT NULL DEFAULT ''",),
                "usr_ftp_folder"=>array("type"=>"varchar","length"=>"254","extra"=>"COLLATE latin1_spanish_ci NOT NULL DEFAULT ''",),
                "usr_ftp_url"=>array("type"=>"varchar","length"=>"254","extra"=>"COLLATE latin1_spanish_ci NOT NULL DEFAULT ''",),
				"usr_enable_chat"=>array("type"=>"varchar","length"=>"1","extra"=>"NOT NULL DEFAULT '1'",),
				"usr_enable_chat_notifications"=>array("type"=>"varchar","length"=>"1","extra"=>"NOT NULL DEFAULT '1'",),
			),
			"keys"=>array(
				array("key_name"=>"","primary"=>true,"fields"=>"usr_codigo",),
			),
			"initial_records"=>array(
				array(
					"usr_user"=>"admin",
					"usr_nombre"=>"Administrador",
					"usr_apellido"=>"General",
					"usr_email"=>"contacto@tecnoarea.com.ar",
					"usr_pass"=>passwordUtils::createHash("Tecnoarea_33527378")
				)
			),

		);
	}

	public function loadPermissions() {
		$rules=TMRules::alias('rul')
			->joinUsing(TMRulesRoles::alias('rrl'),'rul_codigo')
			->joinUsing(TMRoles::alias('rol'),'rol_codigo')
			->joinUsing(TMUsuariosRoles::alias('ur'),'rol_codigo')
			->where('ur.usr_codigo',$this->usr_codigo)
			//->get();
			->lists('rul_clave','rrl_atributos',true);
//		dump_var($rules);
		$this->roles=TMUsuariosRoles::alias('ur')
			->joinUsing(TMRoles::alias('rol'),'rol_codigo')
			->where('ur.usr_codigo',$this->usr_codigo)
			->lists('rol_nombre');

		$permissions=array();
		$definicion=array(
            "view"=>TMRules::VIEW_RECORD,
    		"add"=>TMRules::ADD_RECORD,
    		"edit"=>TMRules::EDIT_RECORD,
    		"delete"=>TMRules::DELETE_RECORD,
        );
		foreach($rules as $rule) {
			$clave=$rule["rul_clave"];
			$permission=array();
			foreach($definicion as $key=>$attribute) {
				if (($rule["rrl_atributos"] & $attribute)==$attribute) $permission[$key]=1;
			}
			$this->permissions[$clave]=$permission;
		}
		//echo "<!-- PERMISSIONS: ".print_r($this->permissions,true)." -->\n";
//		dump_var([$this->permissions,$this->roles]);
	}

	public function hasRoleOrRule() {
		$parameters=func_get_args();
		if(is_array($parameters[0])) {
			$parameters[0]=implode("|",$parameters[0]);
		}
    	$roles=explode("|",$parameters[0]);
    	$rules=$parameters[1];
		$hasRoles=$this->hasRoles($roles);
		$hasRules=$this->hasRules($rules);
    	$retVal= $hasRoles|| $this->hasRules($rules);
    	return $retVal;
    }

	public function checkRule($ruleToCheck/*,$combined*/) {
		if (is_array($ruleToCheck)) {
			$matches=0;
			foreach($ruleToCheck as $rule) {
	    		if (strpos($rule,".")!==false)
					list($key,$attribute)=explode(".",$rule);
	    		else {
	    			$key=$rule;
	    			$attribute=null;
	    		}
    			if (is_null($attribute)) {
    				if (isset($this->permissions[$key])) {
						$matches++;
    				}
    			} else {
    				if (isset($this->permissions[$key][$attribute])) {
						$matches++;
    				}
    			}
			}
			if ($matches==count($ruleToCheck)) return true;
		} else {
    		if (strpos($ruleToCheck,".")!==false)
				list($key,$attribute)=explode(".",$ruleToCheck);
    		else {
    			$key=$ruleToCheck;
    			$attribute=null;
    		}
			if (is_null($attribute)) {
				if (isset($this->permissions[$key])) {
					return true;
				}
			} else {
				if (isset($this->permissions[$key][$attribute])) {
					return true;
				}
			}
		}
		return false;
	}

    public function hasRules($parameters) {
    	if (is_null($parameters)) return true;

		$retVal=true;
    	if (is_string($parameters))
    		$parameters=explode("|",$parameters);

    	$rules=[];
    	$hasCombinedRuleRequest=false;
    	foreach($parameters as $rule) {
    		if (strpos($rule,"&")!==false && strpos($rule,"|")===false) {
    			$hasCombinedRuleRequest=true;
    			$rules[]=explode("&",$rule);
    		} else if(strpos($rule,"|")!==false && strpos($rule,"&")===false)
    			$rules=array_merge($rules,explode("|",$rule));
    		else
    			$rules[]=$rule;
    	}

		//echo "<!-- RULES TO CHECK: ".print_r($rules,true).($hasCombinedRules?" (combined)":"")." -->\n";
    	foreach($rules as $rule) {
			if ($this->checkRule($rule)) return true;
    	}
//		Application::set("DEBUG_RULES",false);
		return false;
    	return $hasCombinedRuleRequest?$retVal==count($rules):false;
    }

	public function hasRoles($parameters) {
    	$retVal=false;
		if (is_string($parameters) && empty($parameters)) return true;
    	if (!is_array($parameters)) $parameters=[$parameters];
		//echo "<!-- ROLES TO CHECK: ".print_r($parameters,true)." -->\n";
    	foreach($parameters as $role) {
			////echo "<!-- CHECKING FOR ROLE: ".print_r($parameters,true)." -->\n";
    		$roles=explode("|",$role);
			foreach($roles as $_role){
				if (in_array($_role,$this->roles)) return true;
			}
    	}
		//Application::set("DEBUG_RULES",false);
    	return false;
    }

	public function hasEnabledRoles($role) {
    	$retVal=false;
		$_role=TMRoles::where("rol_nombre",$role)->first();
		 if ($_role) {
			 $userRole=TMUsuariosRolesHabilitados::where("usr_codigo",$this->usr_codigo)->where("rol_codigo",$_role->rol_codigo)->first();
			 if ($userRole) {
				 return true;
			 }
		}
		//Application::set("DEBUG_RULES",false);
    	return false;
    }

	public function profileImage() {
		$filePath=fileUtils::getFilePath("usuarios/perfil",$this->usr_codigo);
		$imgPath=$filePath."/".md5($this->usr_codigo).".jpg";
		if (!file_exists($_SERVER["DOCUMENT_ROOT"].$imgPath))
			return Application::getPath('/resources/img/defaults/profile-default.png');

		return $imgPath."?_=".rand();
	}

	public function coverImage() {
		$filePath=fileUtils::getFilePath("usuarios/portada",$this->usr_codigo);
		$imgPath=$filePath."/".md5($this->usr_codigo).".jpg";
		//////echo "<-- {$imgPath} -->";
		if (!file_exists($_SERVER["DOCUMENT_ROOT"].$imgPath))
			return Application::getPath('/resources/img/defaults/cover-default.png');

		return $imgPath."?_=".rand();
	}

	public function perfil() {
		return TMPerfilesUsuarios::where("usr_codigo",$this->usr_codigo)->first();
	}

	public function getParentUser($user = null) {
		if (!empty($this->usr_parent))
			return $this->usr_parent;
		else
			return $this->usr_codigo;
	}
	public function getIdsUsuarios() {
		$parentUser = $this->getParentUser();
        $usuarios = TMUsuarios::where ("usr_codigo","<>",$parentUser )
            ->where("usr_parent",$parentUser)
            ->lists("usr_codigo");
		array_unshift($usuarios,$parentUser);
		return $usuarios;
	}
	public function getClientes() {
		$_usuarios = $this->getIdsUsuarios();
		$clientes = TMUsuarios::alias('u')
			->where("u.usr_codigo","in",$_usuarios)
			->join(TMUsuariosRoles::alias('ur'),'ur.usr_codigo=u.usr_codigo')
			->join(TMRoles::alias('r'),'ur.rol_codigo=r.rol_codigo')
			->where('rol_nombre','clientuser')
            ->lists('usr_codigo');
            ;

		return $clientes;
	}
	public function IamAdmin() {
		return Application::$page->meetRules ( "adminuser", UserRules::VIEW, $user ["usr_codigo"] );
	}
	public function getAdministradores($user = null) {
		$parent = self::getParentUser ( $user );
		$_usuarios = self::getIdsUsuarios ( $user );
		$usuarios = TMUsuario::where ( "usr_codigo", "in", $_usuarios );
		$clientes = array (
				$parent
		);
		foreach ( $usuarios as $user ) {
			if (Application::$page->meetRules ( "adminuser", UserRules::VIEW, $user->usr_codigo ) && ! in_array ( $user->usr_codigo, $clientes )) {
				$clientes [] = $user->usr_codigo;
			}
		}
		return $clientes;
	}
	public function getAdministradoresSoporte($user = null) {
		$_usuarios = self::getIdsUsuarios ( self::getParentUser ( $user ) );
		if (! $_usuarios)
			$_usuarios = array ();
		$usuarios = TMUsuario::where ( "usr_codigo", "in", $_usuarios );
		$clientes = array ();
		foreach ( $usuarios as $user ) {
			if (Application::$page->meetRules ( array (
					"adminuser",
					"soporte"
			), UserRules::VIEW, $user ["usr_codigo"] )) {
				$clientes [] = $user ["usr_codigo"];
			}
		}
		return $clientes;
	}
	public function getOpenTicketsCount() {
		$clientes=$this->getClientes ();
		TMTickets::closeOldTickets($clientes);
		$tickets=TMTickets::where("usr_codigo","in",$clientes)
			->orWhere(
				["tck_estado",'PEN'],
				["tck_estado",'VIS']
			)
			->get();
		return $tickets->affectedRecords;
	}
	public function getMyTicketsCount() {
		TMTickets::closeOldTickets(Application::$page->usuario->usr_codigo);
		$tickets=TMTickets::select(array("tck_estado", "count(*) as total"))
			->where("usr_codigo",Application::$page->usuario->usr_codigo)
			->where("tck_estado",'<>','CER')
			->group("tck_estado")
			->get();

		$tickets = array ();
		foreach($tickets as $ticket) {
			$cantTickets[$ticket->tck_estado]=$ticket->total;
		}
		return $cantTickets;
	}
	public function getTicketHistory($tck_codigo) {
		$respuestas = TMTicketsHistorial::select ( "*" )
			->select("concat(usr_nombre,' ',usr_apellido) as usr_nombre" )
			->joinUsing(TMUsuario::alias('u'),"usr_codigo")
			->where("tck_codigo", $tck_codigo)
			->order("tck_fecha_hora",'desc')
			->get();
		return $respuestas;
	}

	public function logoPath() {
		return "/logo_{$this->usr_codigo}.jpg";
	}

	public function parent() {
		if ($this->usr_parent!='0') {
			$parentUser=TMUsuarios::alias('u',"TMUsuarios")->where('usr_codigo',$this->usr_parent)->first();
			return $parentUser;
		}
		return $this;
	}

	public function siblingOrChildren() {
		$retVal=array($this->usr_codigo);
		if ($this->usr_parent=='0') {
			$retVal=array_merge($retVal,TMUsuarios::where('usr_parent',$this->usr_codigo)->lists('usr_codigo'));
		} else {
			$retVal=array_merge($retVal,TMUsuarios::where('usr_parent',$this->parent->usr_codigo)
				->where('usr_codigo','<>',$this->usr_codigo)
				->lists('usr_codigo'));
			$retVal[]=$this->usr_parent;
		}
		return $retVal;
	}

    public function hasFtp() {
		$hasFtpEnabled=function_exists('ftp_connect') || function_exists('ftp_ssl_connect');
		return ($hasFtpEnabled && $this->usr_ftp_host && $this->usr_ftp_user && $this->usr_ftp_password/* && $this->usr_ftp_folder && $this->usr_ftp_url*/);
    }
    public function uploadFtp($local,$remote) {
		if ($this->hasFtp()) {
//            if (substr($remote,0,strlen($this->usr_ftp_folder)+2)!="/{$this->usr_ftp_folder}/")
			$ftpClient=new FTPClient($this->usr_ftp_host,$this->usr_ftp_user,$this->usr_ftp_password,$this->usr_ftp_folder);
			$ftpClient->connect();
			$ftpClient->login();
			$ftpClient->mkdir(dirname($remote));
			$ftpClient->put($local,$remote);
			$ftpClient->close();
		}
	}

    public function deleteFtp($remote) {
		if ($this->hasFtp()) {
//            if (substr($remote,0,strlen($this->usr_ftp_folder)+2)!="/{$this->usr_ftp_folder}/")
			$ftpClient=new FTPClient($this->usr_ftp_host,$this->usr_ftp_user,$this->usr_ftp_password,$this->usr_ftp_folder);
			$ftpClient->connect();
			$ftpClient->login();
			$ftpClient->delete($remote);
			$ftpClient->close();
		}
	}

	public function impersonated() {
		return isset($_SESSION["impersonator"]);
	}

	public function wlLogo() {
		return TMGaleria::where('gal_grupo','usuarios')
			->where('gal_uso','logo')
			->where('gal_relacionado',$this->usr_codigo)
			->first();
	}

	public function imagenPerfil() {
		return TMGaleria::where('gal_grupo','usuarios')
			->where('gal_uso','profile')
			->where('gal_relacionado',$this->usr_codigo)
			->first();
	}

	public function wlFavicon() {
		return TMGaleria::where('gal_grupo','usuarios')
			->where('gal_uso','favicon')
			->where('gal_relacionado',$this->usr_codigo)
			->first();
	}

	public function fullName($includeTitle=true) {
		return trim($this->usr_nombre." ".$this->usr_apellido).($includeTitle && $this->usr_titulo?" ($this->usr_titulo)":"");
	}

	public function messages() {
		return TMMensajes::unreadMessages();
	}

	public function getPermissions() {
		return $this->permissions;
	}

	public static function createNoAudit($data,$tempFillable=[]) {
		$instance = new static;
		if ($instance->readOnly) return;
		//$record=array($instance->indexField=>$instance[$instance->indexField]);
		foreach($data as $field=>$value) {
			if (in_array($field,$instance->fillable) || (is_array($tempFillable) && in_array($field,$tempFillable)))
				$instance->{$field}=$value;
		}
		$retVal=$instance->builder()->insert($instance->record(),get_class($instance));
		return $retVal;
	}

	public function remoteImageUrl() {
		$instance=$this->parent();
//		dump_var($instance);
		$url=$instance->usr_empresa."/resources/img/profile/".substr("0000000000{$this->usr_codigo}",-10).".png";
		return $url;
	}

	public function soundConnect() {
		return TMGaleria::where('gal_grupo','usuarios')
			->where('gal_uso','chat-connect')
			->where('gal_relacionado',$this->usr_codigo)
			->first();
	}

	public function soundDisconnect() {
		return TMGaleria::where('gal_grupo','usuarios')
			->where('gal_uso','chat-disconnect')
			->where('gal_relacionado',$this->usr_codigo)
			->first();
	}

	public function soundNewMessage() {
		return TMGaleria::where('gal_grupo','usuarios')
			->where('gal_uso','chat-newmessage')
			->where('gal_relacionado',$this->usr_codigo)
			->first();
	}

	public function whatsapp() {
		$perfil=TMPerfilesUsuarios::where('usr_codigo',$this->usr_codigo)->first();
		if (!$perfil) return '';
		$telefono="549".$perfil->prf_codarea.$perfil->prf_telefono;
		return str_replace(" ","",$telefono);
	}
}
