<?php
Application::Uses("sys.db.model");

class TModelRulesRoles extends TModel {

	protected $table="tbl_rules_roles";

	public $indexField=null;

	protected $fillable=array(
        "rul_codigo",
        "rol_codigo",
        "rrl_atributos"
    );

    public function hasAttribute($attribute) {
    	return (($this->rrl_atributos & $attribute)==$attribute);
    }

	protected function setupTableStructure() {
		$this->structure=array(
			"fields"=>array(
				"rul_codigo"=>array("type"=>"int","length"=>"11","extra"=>"unsigned NOT NULL DEFAULT '0'",),
				"rol_codigo"=>array("type"=>"int","length"=>"11","extra"=>"unsigned NOT NULL DEFAULT '0'",),
				"rrl_atributos"=>array("type"=>"int","length"=>"4","extra"=>"NOT NULL DEFAULT '15'",),
			),
			"keys"=>array(
			),
			"initial_records"=>array(
				array("rul_codigo"=>5,"rol_codigo"=>3,"rrl_atributos"=>15),
				array("rul_codigo"=>6,"rol_codigo"=>3,"rrl_atributos"=>15),
				array("rul_codigo"=>6,"rol_codigo"=>4,"rrl_atributos"=>8),
				array("rul_codigo"=>6,"rol_codigo"=>6,"rrl_atributos"=>8),
				array("rul_codigo"=>7,"rol_codigo"=>7,"rrl_atributos"=>15),
				array("rul_codigo"=>8,"rol_codigo"=>4,"rrl_atributos"=>15),
				array("rul_codigo"=>9,"rol_codigo"=>2,"rrl_atributos"=>8),
				array("rul_codigo"=>9,"rol_codigo"=>3,"rrl_atributos"=>8),
				array("rul_codigo"=>10,"rol_codigo"=>4,"rrl_atributos"=>8),
				array("rul_codigo"=>11,"rol_codigo"=>5,"rrl_atributos"=>15),
				array("rul_codigo"=>12,"rol_codigo"=>8,"rrl_atributos"=>15),
				array("rul_codigo"=>13,"rol_codigo"=>9,"rrl_atributos"=>15),
				array("rul_codigo"=>14,"rol_codigo"=>10,"rrl_atributos"=>15),
				array("rul_codigo"=>15,"rol_codigo"=>11,"rrl_atributos"=>15),
				array("rul_codigo"=>17,"rol_codigo"=>15,"rrl_atributos"=>15),
				array("rul_codigo"=>18,"rol_codigo"=>16,"rrl_atributos"=>15),
				array("rul_codigo"=>19,"rol_codigo"=>18,"rrl_atributos"=>15),
				array("rul_codigo"=>20,"rol_codigo"=>18,"rrl_atributos"=>15),
				array("rul_codigo"=>21,"rol_codigo"=>19,"rrl_atributos"=>15),
				array("rul_codigo"=>22,"rol_codigo"=>19,"rrl_atributos"=>15),
				array("rul_codigo"=>23,"rol_codigo"=>20,"rrl_atributos"=>15),
				array("rul_codigo"=>24,"rol_codigo"=>21,"rrl_atributos"=>15),
			),
		);
	}

}
