<?php
Application::Uses("sys.db.model");
Application::Uses("sys.db.traits.auditable");
class TModelRules extends TModel {
	use TAuditableTrait;

	const ADD_RECORD = 0x0001;
	const EDIT_RECORD = 0x0002;
	const DELETE_RECORD = 0x0004;
	const VIEW_RECORD = 0x0008;

	protected $table="tbl_rules";

	public $indexField="rul_codigo";

	protected $fillable=array(
        "rul_nombre",
        "rul_clave",
        "rul_atributos",
    );

	public function hasAttribute($attribute) {
    	return (($this->rul_atributos & $attribute)==$attribute);
    }

	public static function actionToAttribute($action) {
		$actions=array(
			"insertar"=>"add",
			"actualizar"=>"edit",
			"eliminar"=>"delete"
		);
		return $actions[$action];
	}

	public static function ensureRuleAttribute($rules,$attribute) {
		if (!is_array($rules)) $rules=explode("|",$rules);
		foreach($rules as &$rule) {
			list($r,$a)=explode(".",$rule);
			$rule=$r.".delete";
		}
		return $rules;
	}
	protected function setupTableStructure() {
		$this->structure=array(
			"fields"=>array(
				"rul_codigo"=>array("type"=>"int","length"=>"11","extra"=>"unsigned NOT NULL AUTO_INCREMENT",),
				"rul_nombre"=>array("type"=>"varchar","length"=>"64","extra"=>"NOT NULL DEFAULT ''",),
				"rul_clave"=>array("type"=>"varchar","length"=>"64","extra"=>"NOT NULL DEFAULT ''",),
				"rul_atributos"=>array("type"=>"int","length"=>"4","extra"=>"unsigned NOT NULL default '15'",),
			),
			"keys"=>array(
				array("key_name"=>"","primary"=>true,"fields"=>"rul_codigo"),
			),
			"initial_records"=>array(
				/* 01 */ array("rul_nombre"=>"Reglas","rul_clave"=>"reglas","rul_atributos"=>15),
				/* 02 */ array("rul_nombre"=>"Roles","rul_clave"=>"roles","rul_atributos"=>15),
				/* 03 */ array("rul_nombre"=>"Usuarios","rul_clave"=>"usuarios","rul_atributos"=>15),
				/* 04 */ array("rul_nombre"=>"Bandeja de Salida","rul_clave"=>"mensajes","rul_atributos"=>15),
				/* 05 */ array("rul_nombre"=>"Administracion de usuarios","rul_clave"=>"subusuarios","rul_atributos"=>15),
				/* 06 */ array("rul_nombre"=>"Sistema de archivos","rul_clave"=>"filesystem","rul_atributos"=>15),
				/* 07 */ array("rul_nombre"=>"Sistema de Soporte","rul_clave"=>"soporte","rul_atributos"=>15),
				/* 08 */ array("rul_nombre"=>"Tickets","rul_clave"=>"tickets","rul_atributos"=>15),
				/* 09 */ array("rul_nombre"=>"Administrador","rul_clave"=>"adminuser","rul_atributos"=>15),
				/* 10 */ array("rul_nombre"=>"Cliente","rul_clave"=>"clientuser","rul_atributos"=>15),
				/* 11 */ array("rul_nombre"=>"Sistema de Noticias","rul_clave"=>"noticias","rul_atributos"=>15),
				/* 12 */ array("rul_nombre"=>"Productos","rul_clave"=>"productos","rul_atributos"=>15),
				/* 13 */ array("rul_nombre"=>"Videos","rul_clave"=>"videos","rul_atributos"=>15),
				/* 14 */ array("rul_nombre"=>"Galeria Imagenes","rul_clave"=>"galerias","rul_atributos"=>15),
				/* 15 */ array("rul_nombre"=>"Sliders","rul_clave"=>"sliders","rul_atributos"=>15),
				/* 17 */ array("rul_nombre"=>"DUMMY","rul_clave"=>"no-use","rul_atributos"=>15),
				/**
				 *------------- Permisos V2
				 */
				/* 17 */ array("rul_nombre"=>"Idiomas","rul_clave"=>"idiomas","rul_atributos"=>15),
				/* 18 */ array("rul_nombre"=>"Paises","rul_clave"=>"paises","rul_atributos"=>15),
				/* 19 */ array("rul_nombre"=>"Categorias","rul_clave"=>"categorias","rul_atributos"=>15),
				/* 20 */ array("rul_nombre"=>"Sub Categorias","rul_clave"=>"subcategorias","rul_atributos"=>15),
				/* 21 */ array("rul_nombre"=>"Agrupaciones de Productos","rul_clave"=>"agrupaciones","rul_atributos"=>15),
				/* 22 */ array("rul_nombre"=>"Sub Agrupaciones de Productos","rul_clave"=>"subagrupaciones","rul_atributos"=>15),
				/* 23 */ array("rul_nombre"=>"Accesorios","rul_clave"=>"accesorios","rul_atributos"=>15),
				/* 24 */ array("rul_nombre"=>"Variaciones","rul_clave"=>"variaciones","rul_atributos"=>15),
				/* 25 */ array("rul_nombre"=>"Suplantar Identidad","rul_clave"=>"impersonar","rul_atributos"=>15),

			),
		);
	}

    public function rules_event_tablePopulated() {
		$className=get_class($this);
		$instance=$this->initBuilder();
		$record=$instance->where('rul_codigo','16',$className)->first();
		$record->delete();
    }
}
