<?php
Application::Uses("sys.db.model");

Application::UsesModel("rules_roles","TMRulesRoles");

class TModelRoles extends TModel {

	protected $table="tbl_roles";

	public $indexField="rol_codigo";

	protected $fillable=array(
        "rol_nombre"
    );

	public function rules() {
		return TMRulesRoles::where('rrl_codrol',$this->rol_codigo)->get();
	}

	protected function setupTableStructure() {
		$this->structure=array(
			"fields"=>array(
				"rol_codigo"=>array("type"=>"int","length"=>"11","extra"=>"unsigned NOT NULL AUTO_INCREMENT",),
				"rol_nombre"=>array("type"=>"varchar","length"=>"64","extra"=>"NOT NULL DEFAULT ''",),
			),
			"keys"=>array(
				array("key_name"=>"","primary"=>true,"fields"=>"rol_codigo"),
			),
			"initial_records"=>array(
				/* 01 */ array("rol_nombre"=>"Superusuario"),
				/* 02 */ array("rol_nombre"=>"Administrador"),
				/* 03 */ array("rol_nombre"=>"Administrar Usuario y Enviar Archivos"),
				/* 04 */ array("rol_nombre"=>"Cliente"),
				/* 05 */ array("rol_nombre"=>"Sistema de Noticias"),
				/* 06 */ array("rol_nombre"=>"Recibir Archivos"),
				/* 07 */ array("rol_nombre"=>"Sistema de Soporte"),
				/* 08 */ array("rol_nombre"=>"Productos"),
				/* 09 */ array("rol_nombre"=>"Videos"),
				/* 10 */ array("rol_nombre"=>"Galerias de Imagenes"),
				/* 11 */ array("rol_nombre"=>"Sliders"),
				/* 12 */ array("rol_nombre"=>"DUMMY"),
				/* 13 */ array("rol_nombre"=>"DUMMY"),
				/* 14 */ array("rol_nombre"=>"Administrar Archivos"),
				/* 15 */ array("rol_nombre"=>"Idiomas"),
				/* 16 */ array("rol_nombre"=>"Paises"),
				/* 17 */ array("rol_nombre"=>"DUMMY"),
				/* 18 */ array("rol_nombre"=>"Categorias"),
				/* 19 */ array("rol_nombre"=>"Agrupaciones Productos"),
				/* 20 */ array("rol_nombre"=>"Accesorios Productos"),
				/* 21 */ array("rol_nombre"=>"Variaciones Productos"),
				/* 22 */ array("rol_nombre"=>"Redaccion Noticias"),
			),
		);
	}

    public function roles_event_tablePopulated() {
        $className=get_class($this);
		$instance=$this->initBuilder();
		$record=$instance->where('rol_codigo','12',$className)->first();
		$record->delete();
		$instance=$this->initBuilder();
		$record=$instance->where('rol_codigo','13',$className)->first();
		$record->delete();
		$instance=$this->initBuilder();
		$record=$instance->where('rol_codigo','17',$className)->first();
		$record->delete();
    }

}
