<?php
class TModelPerfilesUsuarios extends TModel {

	protected $table="tbl_perfiles_usuarios";
	protected $dates=['prf_fecha_nacimiento'];
	protected $fillable=array(
		'usr_codigo',
		'prf_tipo',
		'prf_ciudad',
		'prf_provincia',
		'prf_pais',
		'prf_codarea',
		'prf_telefono',
		'prf_dni',
		'prf_fecha_nacimiento',
	);
	public $indexField="prf_codigo";

	protected function setupTableStructure() {
		$this->structure=array(
			"fields"=>array(
				"prf_codigo"=>array("type"=>"int","length"=>"11","extra"=>"unsigned NOT NULL AUTO_INCREMENT",),
				"usr_codigo"=>array("type"=>"int","length"=>"11","extra"=>"unsigned NOT NULL DEFAULT '0'",),
				"prf_ciudad"=>array("type"=>"varchar","length"=>"64","extra"=>"COLLATE latin1_spanish_ci NOT NULL DEFAULT ''",),
				"prf_provincia"=>array("type"=>"varchar","length"=>"64","extra"=>"COLLATE latin1_spanish_ci NOT NULL DEFAULT ''",),
				"prf_pais"=>array("type"=>"varchar","length"=>"64","extra"=>"COLLATE latin1_spanish_ci NOT NULL DEFAULT ''",),
				"prf_dni"=>array("type"=>"varchar","length"=>"64","extra"=>"COLLATE latin1_spanish_ci NOT NULL DEFAULT ''",),
				"prf_codarea"=>array("type"=>"varchar","length"=>"10","extra"=>"COLLATE latin1_spanish_ci NOT NULL DEFAULT ''",),
				"prf_telefono"=>array("type"=>"varchar","length"=>"64","extra"=>"COLLATE latin1_spanish_ci NOT NULL DEFAULT ''",),
				"prf_fecha_nacimiento"=>array("type"=>"date","extra"=>"COLLATE latin1_spanish_ci NOT NULL DEFAULT '0000-00-00'",),
			),
			"keys"=>array(
				array("key_name"=>"","primary"=>true,"fields"=>"prf_codigo"),
			),
		);
	}
}
