<?php
Application::uses("sys.tools.utils.datesUtils");
Application::usesModel('carpetas_mensajes');
Application::usesModel('mensajes_destinatarios');

class TModelMensajes extends TModel {

    const MSG_UNREAD        = 0x0001;
	const MSG_READ          = 0x0002;
	const MSG_ANSWERED      = 0x0004;
    const MSG_FORWARDED     = 0x0008;

    protected $table="tbl_mensajes";

	public $indexField="msg_codigo";

	protected $dates=array('msg_enviado');
    protected $skipEncoding=array("msg_cuerpo");
	protected $fillable=array(
        'usr_codigo',
        'msf_codigo',
		'msg_estado',
		'msg_asunto',
		'msg_cuerpo',
		'msg_autor',
        'msg_enviado',
        'msg_to',
    );

    protected function setupTableStructure() {
		$this->structure=array(
			"fields"=>array(
                "msg_codigo"=>array("type"=>"int","length"=>"11","extra"=>"unsigned NOT NULL AUTO_INCREMENT",),
                "usr_codigo"=>array("type"=>"int","length"=>"11","extra"=>"unsigned NOT NULL DEFAULT '0'",),
                "msf_codigo"=>array("type"=>"int","length"=>"11","extra"=>"unsigned NOT NULL DEFAULT '0'",),
                "msg_estado"=>array("type"=>"int","length"=>"11","extra"=>"unsigned NOT NULL DEFAULT '0'",),
                "msg_autor"=>array("type"=>"int","length"=>"11","extra"=>"unsigned NOT NULL DEFAULT '0'",),
                "msg_asunto"=>array("type"=>"varchar","length"=>"64","extra"=>"COLLATE latin1_spanish_ci NOT NULL DEFAULT ''",),
                "msg_cuerpo"=>array("type"=>"text","extra"=>"COLLATE latin1_spanish_ci NOT NULL DEFAULT ''",),
                "msg_enviado"=>array("type"=>"datetime","length"=>"","extra"=>"NOT NULL DEFAULT '0000-00-00 00:00:00'",),
                "msg_to"=>array("type"=>"text","extra"=>"NOT NULL DEFAULT ''",),
            ),
			"keys"=>array(
                array("key_name"=>"","primary"=>true,"fields"=>"msg_codigo",),
			),
			"initial_records"=>array(
			),
		);
	}

    public function remitente() {
        return TMUsuarios::find($this->msg_autor);
    }

    public function destinatario() {
        return TMUsuarios::find($this->usr_codigo);
    }

    public function destinatarios() {
        return TMUsuarios::alias('u')->select('u.*')
            ->joinUsing(TMMensajesDestinatarios::alias('md'),'usr_codigo')
            ->where('md.msg_codigo',$this->msg_codigo)
            ->get();
    }

    public function age() {
        $msgEnviado=new datesUtils($this->internationalDate("msg_enviado"));
        return $msgEnviado->elapsed();
    }

    public static function unreadMessages() {
        return static::where('usr_codigo',Application::$page->usuario->usr_codigo)
            ->where('(msg_estado & '.TMMensajes::MSG_UNREAD.') <> 0')
            ->where('msf_codigo',Application::$page->messagesFolders['inbox'])
            ->order('msg_enviado')
            ->get();
    }

    public function draftMessages() {
        return TMMensajes::where('msf_codigo',Application::$page->messagesFolders["folder_id"]['borradores'])->get();
    }
}
