<?php
Application::Uses("sys.db.model");
class TModelLoginUsuarios extends TModel {
    protected $table="tbl_login_usuarios";
    public $indexField="lgn_codigo";
    protected $dates=array('lgn_fecha_hora');
    protected $fillable=[
        'usr_codigo',
        'lgn_fecha_hora',
        'lgn_address',
        'lgn_device'
    ];

    protected function setupTableStructure() {
		$this->structure=array(
			"fields"=>array(
				"lgn_codigo"=>array("type"=>"int","length"=>"11","extra"=>"unsigned NOT NULL AUTO_INCREMENT",),
				"lgn_fecha_hora"=>array("type"=>"datetime","extra"=>"NULL DEFAULT '0000-00-00 00:00:00'",),
				"lgn_address"=>array("type"=>"varchar","length"=>"64","extra"=>"NOT NULL DEFAULT ''",),
                "lgn_device"=>array("type"=>"varchar","length"=>"128","extra"=>"NOT NULL DEFAULT ''",),
				"usr_codigo"=>array("type"=>"int","length"=>"11","extra"=>"NOT NULL DEFAULT '1'",),
			),
			"keys"=>array(
				array("key_name"=>"","primary"=>true,"fields"=>"lgn_codigo",),
			),
			"initial_records"=>array(
			),

		);
	}
}
