<?php
class TModelCarpetasMensajes extends TModel {

    protected $table="tbl_carpetas_mensajes";

	public $indexField="msf_codigo";

	protected $fillable=array(
        'usr_codigo',
		'msf_nombre'
    );

    protected function setupTableStructure() {
		$this->structure=array(
			"fields"=>array(
                "msf_codigo"=>array("type"=>"int","length"=>"11","extra"=>"unsigned NOT NULL AUTO_INCREMENT",),
                "usr_codigo"=>array("type"=>"int","length"=>"11","extra"=>"unsigned NULL DEFAULT '0'",),
                "msf_nombre"=>array("type"=>"varchar","length"=>"64","extra"=>"COLLATE latin1_spanish_ci NOT NULL DEFAULT ''",),
            ),
			"keys"=>array(
                array("key_name"=>"","primary"=>true,"fields"=>"msf_codigo",),
			),
			"initial_records"=>array(
			),
		);
	}

    public function verificarCarpetas($usr_codigo=false) {
        $carpetas=TMCarpetasMensajes::where('usr_codigo',$usr_codigo?$usr_codigo:Application::$page->usuario->usr_codigo)
            ->get();
        $fld=array();
        foreach($carpetas as $carpeta) {
            $fld["folder_id"][$carpeta->msf_nombre]=$carpeta->msf_codigo;
            $fld["id_folder"][$carpeta->msf_codigo]=$carpeta->msf_nombre;
        }
        foreach(array("inbox","enviados","papelera","importantes","borradores") as $folder) {
            if (!isset($fld["folder_id"][$folder])) {
                $carpeta=TMCarpetasMensajes::create(array(
                    "usr_codigo"=>$usr_codigo?$usr_codigo:Application::$page->usuario->usr_codigo,
                    "msf_nombre"=>$folder
                ));
                $fld["folder_id"][$carpeta->msf_nombre]=$carpeta->msf_codigo;
                $fld["id_folder"][$carpeta->msf_codigo]=$carpeta->msf_nombre;
            }
        }
        return $fld;
    }
}
