<?php
Application::Uses("sys.db.model");

class TModelAudit extends TModel {

    protected $table="tbl_audit";

	public $indexField="log_codigo";

	protected $fillable=array("log_date","log_address","usr_codigo","log_device","log_activity",'log_table','log_record');

    protected $dates=["log_date"];
    protected function setupTableStructure() {
		$this->structure=array(
			"fields"=>array(
				"log_codigo"=>array("type"=>"int","length"=>"11","extra"=>"unsigned NOT NULL AUTO_INCREMENT",),
				"log_date"=>array("type"=>"datetime","extra"=>"NULL DEFAULT '0000-00-00 00:00:00'",),
				"log_address"=>array("type"=>"varchar","length"=>"64","extra"=>"NOT NULL DEFAULT ''",),
                "log_device"=>array("type"=>"varchar","length"=>"128","extra"=>"NOT NULL DEFAULT ''",),
                "log_activity"=>array("type"=>"varchar","length"=>"128","extra"=>"NOT NULL DEFAULT ''",),
                "log_table"=>array("type"=>"varchar","length"=>"128","extra"=>"NOT NULL DEFAULT ''",),
                "log_record"=>array("type"=>"text","extra"=>"NOT NULL",),
				"usr_codigo"=>array("type"=>"int","length"=>"11","extra"=>"NOT NULL DEFAULT '1'",),
			),
			"keys"=>array(
				array("key_name"=>"","primary"=>true,"fields"=>"log_codigo",),
			),
			"initial_records"=>array(
			),

		);
	}

    public static function auditTable($activity, $model) {
        if (Application::$page) {
            $userSessionVar=Application::$page->sessionUser();
            if (is_null($_SESSION[$userSessionVar])) return;
            $usr_codigo=$_SESSION[$userSessionVar];
        } else {
            $usr_codigo=1;
        }
        $data=array(
            "log_date"=>date("Y-m-d H:i:s",time()),
            "log_activity"=>$activity,
            "log_address"=>$_SERVER["REMOTE_ADDR"],
            "log_device"=>$_SERVER["HTTP_USER_AGENT"],
            "log_table"=>$model->getTableName(),
            "log_record"=>serialize($model->record()),
            "usr_codigo"=>$usr_codigo
        );
        self::create($data);
        return $model;
    }

    public function usuario()  {
        return TMUsuarios::find($this->usr_codigo);
    }

}
