<?php
Application::Uses("sys.db.model");

class TModelActivities extends TModel {

    const LOG_ACTIVITY 		= 0x0001;
    const LOG_AUDIT 		= 0x0002;

    protected $table="tbl_activities";

	public $indexField="log_codigo";

	protected $fillable=array("log_date","log_address","usr_codigo","log_device",'log_level',"log_activity");

    protected $dates=["log_date"];
    protected function setupTableStructure() {
		$this->structure=array(
			"fields"=>array(
				"log_codigo"=>array("type"=>"int","length"=>"11","extra"=>"unsigned NOT NULL AUTO_INCREMENT",),
				"log_date"=>array("type"=>"datetime","extra"=>"NULL DEFAULT '0000-00-00 00:00:00'",),
				"log_address"=>array("type"=>"varchar","length"=>"64","extra"=>"NOT NULL DEFAULT ''",),
                "log_device"=>array("type"=>"varchar","length"=>"128","extra"=>"NOT NULL DEFAULT ''",),
                "log_activity"=>array("type"=>"varchar","length"=>"128","extra"=>"NOT NULL DEFAULT ''",),
                "log_level"=>array("type"=>"int","length"=>"11","extra"=>"NOT NULL DEFAULT '1'",),
				"usr_codigo"=>array("type"=>"int","length"=>"11","extra"=>"NOT NULL DEFAULT '1'",),
			),
			"keys"=>array(
				array("key_name"=>"","primary"=>true,"fields"=>"log_codigo",),
			),
			"initial_records"=>array(
			),

		);
	}

    public static function logActivity($actividad,$level=1,$usr_codigo=null) {
        if (is_null($_SESSION["user"]) && is_null($_SESSION["cliente"])) return;
        $data=array(
            "log_date"=>date("Y-m-d H:i:s",time()),
            "log_activity"=>$actividad,
            "log_address"=>$_SERVER["REMOTE_ADDR"],
            "log_device"=>$_SERVER["HTTP_USER_AGENT"],
            "log_level"=>$level,
            "usr_codigo"=>!$usr_codigo?($_SESSION["user"]?$_SESSION["user"]:$_SESSION["cliente"]):$usr_codigo
        );
        self::create($data);
    }

    public function usuario()  {
        return TMUsuarios::find($this->usr_codigo);
    }

}
